<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="RCMR_MT010001">
    <title>Consentdirective</title>
    <rule context="$element">
        <assert role="error" test="@moodCode='EVN'">RCMR_MT010001NL: consentDirective/@moodCode moet 'EVN' zijn</assert>
        <assert role="error" test="not(hl7:reasonCode)">RCMR_MT010001NL: consentDirective/reasonCode niet gebruiken</assert>
        <assert role="error" test="not(hl7:author1)">RCMR_MT010001NL: consentDirective/author1 niet gebruiken</assert>
        <assert role="error" test="not(hl7:documentationOf)">RCMR_MT010001NL: consentDirective/documentationOf niet gebruiken</assert>
        <assert role="error" test="not(hl7:sourceOf)">RCMR_MT010001NL: consentDirective/sourceOf niet gebruiken</assert>
        <assert role="error" test="count(hl7:author2) &lt; 2">RCMR_MT010001NL: consentDirective/author2 mag maar één keer voorkomen</assert>
    </rule>
    
    <rule context="$element/hl7:code">
        <assert role="error" test="@code='INFA' and @codeSystem='2.16.840.1.113883.5.4'">RCMR_MT010001NL: consentDirective/code moet 'INFA' zijn uit
            '2.16.840.1.113883.5.4'</assert>
    </rule>
    <rule context="$element/hl7:statusCode">
        <assert role="error" test="@code='active'">RCMR_MT010001NL: consentDirective/statusCode moet 'active' zijn</assert>
    </rule>
    <rule context="$element/hl7:effectiveTime">
        <assert role="error" test="hl7:low and string-length(hl7:low/@value) &gt;= 8 and count(*) = 1">RCMR_MT010001NL: consentDirective/effectiveTime mag alleen een low
            hebben (datum vanaf) welke tenminste tot op de dag precies is</assert>
    </rule>
    
    <title>subject</title>
    <rule context="$element/hl7:subject">
        <assert role="error" test="hl7:patient">RCMR_MT010001NL: consentDirective/subject mag alleen met patient worden gebruikt</assert>
    </rule>
    <rule context="$element/hl7:subject/hl7:patient/hl7:id">
        <assert role="error" test=".[@root='2.16.840.1.113883.2.4.6.3']">RCMR_MT010001NL: consentDirective/subject/patient moet tenminste met een BSN worden
            geïdentificeerd</assert>
    </rule>
    
    
    <title>author2</title>
    <rule context="$element/hl7:author2">
        <assert role="error" test="hl7:patient or hl7:functionCode">RCMR_MT010001NL: consentDirective/author2/functionCode moet aanwezig zijn indien author2 niet de patiënt
            zelf is</assert>
        <assert role="error" test="not(hl7:signatureCode)">RCMR_MT010001NL: consentDirective/author2/signatureCode is niet toegestaan</assert>
        <assert role="error" test="not(hl7:signatureText)">RCMR_MT010001NL: consentDirective/author2/signatureText is niet toegestaan</assert>
    </rule>
    <rule context="$element/hl7:author2/hl7:functionCode">
        <assert role="error" test=".[@codeSystem='2.16.840.1.113883.5.88']">RCMR_MT010001NL: consentDirective/author2/functionCode moet uit codeSystem '2.16.840.1.113883.5.88'
            komen</assert>
    </rule>
    <rule context="$element/hl7:author2/hl7:time">
        <assert role="error" test="@value and string-length(@value) &gt;= 8 and count(*) = 0">RCMR_MT010001NL: consentDirective/author2/time mag alleen value hebben welke
            tenminste tot op de dag precies is en mag geen periode-elementen bevatten (low, high, center, mid)</assert>
        <assert role="error" test="number(substring(@value,1,8)) &lt;= number(substring(../../hl7:effectiveTime/hl7:low/@value,1,8))"
            >RCMR_MT010001NL: consentDirective/author2/time datum '<value-of select="substring(@value,1,8)"/>' moet gelijk zijn of liggen voor de datum '<value-of
                select="substring(../../hl7:effectiveTime/hl7:low/@value,1,8)"/>' van subject2/consentDirective</assert>
    </rule>
    <rule context="$element/hl7:author2/hl7:modeCode">
        <assert role="error" test=".[@codeSystem='2.16.840.1.113883.5.1064']">RCMR_MT010001NL: consentDirective/author2/modeCode moet uit codeSystem '2.16.840.1.113883.5.1064'
            komen</assert>
    </rule>
    
    
    <title>author2/responsibleParty</title>
    <rule context="$element/hl7:author2/hl7:responsibleParty">
        <let name="author2IdRoot" value="hl7:id/@root"/>
        <let name="author2IdExt" value="hl7:id/@extension"/>
        <assert role="error" test="../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:id[@root=$author2IdRoot and @extension=$author2IdExt]"
            >RCMR_MT010001NL: responsibleParty/id moet dezelfde zijn als de overseer/AssignedPerson/id</assert>
        <assert role="error" test="not(../../hl7:subject/hl7:patient/hl7:id[@root=$author2IdRoot and @extension=$author2IdExt])"
            >RCMR_MT010001NL: als de verantwoordelijke partij (responsibleParty) de patiënt is, dan moet Patient worden gebruikt.</assert>
        
        <let name="author2Code" value="hl7:code/@code"/>
        <let name="author2CodeSystem" value="hl7:code/@codeSystem"/>
        <assert role="error"
            test="if (../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:code) then ( 
            ../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:code[@code=$author2Code and @codeSystem=$author2CodeSystem] ) else (
            not(hl7:code) )"
            >RCMR_MT010001NL: responsibleParty/code moet dezelfde zijn als de overseer/AssignedPerson/code</assert>
        
        <assert role="error"
            test="if (../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name) then (
            count(../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name/node()) = count(hl7:agentPerson/hl7:name/node())
            ) else (
            not(hl7:name)
            )"
            >RCMR_MT010001NL: responsibleParty/agentPerson/name moet dezelfde zijn als de naam van de overseer</assert>
        
        <assert role="error"
            test="if (../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:addr) then (
            count(../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:addr/node()) = count(hl7:agentPerson/hl7:addr/node())
            ) else (
            not(hl7:addr)
            )"
            >RCMR_MT010001NL: responsibleParty/agentPerson/addr moet dezelfde zijn als het adres van de overseer</assert>
    </rule>
    
    <title>author2/responsibleParty/representedOrganization</title>
    <rule context="$element/hl7:author2/hl7:responsibleParty/hl7:representedOrganization">
        <assert role="error"
            test="if (../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/@nullFlavor) then (
            ../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/@nullFlavor = hl7:representedOrganization/@nullFlavor 
            ) else (
            not(hl7:representedOrganization/@nullFlavor)
            )"
            >RCMR_MT010001NL: responsibleParty/representedOrganization moet indien aanwezig dezelfde nullFlavor hebben als de
            overseer/AssignedPerson/Organization</assert>
        
        <let name="author2OrgIdRoot" value="hl7:representedOrganization/hl7:id/@root"/>
        <let name="author2OrgIdExt" value="hl7:representedOrganization/hl7:id/@extension"/>
        <assert role="error"
            test="if (../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:id/@nullFlavor) then (
            ../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:id/@nullFlavor = hl7:representedOrganization/hl7:id/@nullFlavor 
            ) else (
            ../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:id[@root=$author2OrgIdRoot and @extension=$author2OrgIdExt]
            )"
            >RCMR_MT010001NL: responsibleParty/representedOrganization/id moet dezelfde zijn als de overseer/AssignedPerson/Organization/id</assert>
        
        <let name="author2OrgCode" value="hl7:representedOrganization/hl7:code/@code"/>
        <let name="author2OrgCodeSystem" value="hl7:representedOrganization/hl7:code/@codeSystem"/>
        <assert role="error"
            test="if (../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:code) then ( 
            ../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:code[@code=$author2OrgCode and @codeSystem=$author2OrgCodeSystem] 
            ) else (
            not(hl7:representedOrganization/hl7:code)
            )"
            >RCMR_MT010001NL: responsibleParty/representedOrganization/code moet dezelfde zijn als de overseer/AssignedPerson/Organization/code</assert>
        
        <assert role="error"
            test="if (../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:name) then (
            count(../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:name/node()) = count(hl7:representedOrganization/hl7:name/node())
            ) else (
            not(hl7:representedOrganization/hl7:name)
            )"
            >RCMR_MT010001NL: responsibleParty/representedOrganization/name moet dezelfde zijn als de organisatienaam van de overseer</assert>
        
        <assert role="error"
            test="if (../../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:addr) then (
            count(../../../../../../hl7:overseer/hl7:AssignedPerson/hl7:Organization/hl7:addr/node()) = count(hl7:representedOrganization/hl7:addr/node())
            ) else (
            not(hl7:representedOrganization/hl7:addr)
            )"
            >RCMR_MT010001NL: responsibleParty/representedOrganization/addr moet dezelfde zijn als het organisatieadres van de overseer</assert>
    </rule>
    
    <title>component</title>
    <rule context="$element/hl7:component">
        <assert role="error" test="not(@contextConductionInd) or @contextConductionInd='true'">contextConductionInd moet indien aanwezig 'true' zijn</assert>
    </rule>
    
    <title>component/permissionToTransfer</title>
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer">
        <assert role="error" test="count(hl7:subject) =1">RCMR_MT010001NL: component/permissionToTransfer/subject moet exact één maal voorkomen</assert>
    </rule>
    
    <title>component/permissionToTransfer/id</title>
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer/hl7:id">
        <assert role="error" test="not(.)">RCMR_MT010001NL: component/permissionTransfer/id mag niet gebruikt worden'</assert>
    </rule>
    
    <title>component/permissionToTransfer/code</title>
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer/hl7:code">
        <assert role="error" test="@code='INFCON' and @codeSystem='2.16.840.1.113883.5.4'">RCMR_MT010001NL: component/permissionTransfer/code moet 'INFCON'
            zijn uit '2.16.840.1.113883.5.4'</assert>
    </rule>
    
    <title>component/permissionToTransfer/receiver</title>
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer/hl7:receiver">
        <assert role="error" test="not(../../../../hl7:consentDirective/@negationInd='true' and 
            (../@negationInd='false' or not(../@negationInd)))"
            >RCMR_MT010001NL: Er kunnen geen receiver relaties zijn bij "Totaal bezwaar"</assert>
        <assert role="error" test="not((../../../../hl7:consentDirective/@negationInd='false' or not(../../../../hl7:consentDirective/@negationInd)) and 
            (../@negationInd='false' or not(../@negationInd)))"
            >RCMR_MT010001NL: Er kunnen geen receiver relaties zijn bij "Geen bezwaar"</assert>
        <assert role="error" test="not(hl7:functionCode)">component/receiver/functionCode niet gebruiken</assert>
    </rule>
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer/hl7:receiver/hl7:assignedEntity/hl7:id">
        <assert role="error" test="(not(@nullFlavor) and count(../*) = 1) or (@nullFlavor='NA' and ../hl7:code and count(../*) = 2)"
            >RCMR_MT010001NL: component/receiver/assignedEntity/id mag een waarde hebben, maar er mogen dan geen andere elementen zijn. Indien id een nullFlavor
            heeft, moet deze 'NA' zijn, maar dan moet element code ook worden gebruikt</assert>
        
        <assert role="error" test="@nullFlavor='NA' or @root='2.16.528.1.1007.3.1' or @root='2.16.528.1.1007.3.3'">RCMR_MT010001NL: component/receiver/assignedEntity/id moet
            indien deze een waarde heeft komen uit '2.16.528.1.1007.3.1' (Zorgverleners) of '2.16.528.1.1007.3.3' (Zorgaanbieders)</assert>
        
        <assert role="error" test="not(@nullFlavor='NA') or (../hl7:code[not(@nullFlavor)] and count(../*) = 2)">RCMR_MT010001NL: component/receiver/assignedEntity/id heeft
            nullFlavor='NA', dus moet er een assignedEntity/code zijn en geen andere elementen</assert>
    </rule>
    
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer/hl7:receiver/hl7:assignedEntity/hl7:code">
        <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.111'">RCMR_MT010001NL: component/receiver/assignedEntity/code moet indien deze een waarde heeft komen
            uit '2.16.840.1.113883.2.4.15.111' (RoleCodeNL)</assert>
    </rule>
    
    <title>component/permissionToTransfer/subject</title>
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer/hl7:subject">
        <assert role="error" test="not(@contextConductionInd) or @contextConductionInd='false'">RCMR_MT010001NL: contextConductionInd moet indien aanwezig 'false' zijn</assert>
    </rule>
    
    <rule
        context="$element/hl7:component/hl7:permissionToTransfer/hl7:subject/hl7:recordType/hl7:code">
        <assert role="error" test="@code='ACPROV' and @codeSystem='2.16.840.1.113883.5.4'">RCMR_MT010001NL: component/permissionTransfer/subject/recordType/code moet 'ACPROV'
            zijn uit '2.16.840.1.113883.5.4'</assert>
    </rule>
    
</pattern>